;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeTaskSchedules.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.3  $
;          $Date:   07 Oct 2005 17:18:08  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeTaskSchedules.MM.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; Shows how schedules can be created.
;
; I prefer to run all schedules via a batch file, not only to make up for
; Windows comamnd line restrictions (length and content) but also so that
; I can be positive I will end up with a log so I can diagnose failures.
; If you ran a vbscript which did its own logging, you could still miss
; details about any exceptions.
;
; Also note that I use the following in the example:
;
;      Parameters = "/C echo %DATE% %TIME%: ...
;
; This will not work as expected in WinNT as "date" and "time" variables
; don't exist (it still works as an example).
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;--- This script requires some user preparation (JT.EXE required) -----------
;----------------------------------------------------------------------------
#if FileQueryExists("JT.EXE") = ''
    #error ^Sorry but you must download and place the Microsoft "JT.EXE" tool{NL}next to this script.^
#endif


;----------------------------------------------------------------------------
;--- Override some MAKEMSI options ------------------------------------------
;----------------------------------------------------------------------------
#define VER_FILENAME.VER                                   TryMe.Ver  ;;I only want one VER file for all samples!
#define SCHEDULE_JT_USE_TMPFILE_TO_SHORTEN_CMDLINE_INSTALL Y          ;;Ensure it should be OK in WinNT


;----------------------------------------------------------------------------
;--- Include MAKEMSI support (with my customisations and MSI branding) ------
;----------------------------------------------------------------------------
#include "ME.MMH"


;---[4Doco-SimpleJtExeBasedSchedule]---
;----------------------------------------------------------------------------
;--- Create INSTALLDIR ------------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="INSTALLDIR" Dir="c:\program files\TryMe (makemsi sample)\<$MAKEMSI_MM_BASENAME>" CHANGE="\" PrimaryFolder="Y">


;----------------------------------------------------------------------------------------------
;--- Our schedules will be created by JT.EXE (so unless already on box we must install it!) ---
;----------------------------------------------------------------------------------------------
<$Files "jt.exe" DestDir="INSTALLDIR">


;--------------------------------------------------------------------------------------------------------------
;--- Any information that can't be hard coded (install directory etc) must be passed to the schedule script ---
;--------------------------------------------------------------------------------------------------------------
#data "CAD_SCHEDULE"
   "INSTALLDIR"          "[INSTALLDIR]"              ;;Want to know the installation directory
   "Schedule1Comment"    "Runs simple CMD.EXE task"  ;;Comment for schedule #1/2
   "Schedule2Comment"    "Runs VBS (logs progress)"  ;;Comment for schedule #2/2
#data


;----------------------------------------------------------------------------
;--- Create Schedule #1: A simple "silly" schedule --------------------------
;----------------------------------------------------------------------------
<$Schedule "SillySchedule1 - (*Schedule1Comment*)" DATA="CAD_SCHEDULE" JT.EXE=^[INSTALLDIR]JT.EXE^>
   ;--- Task Information ----------------------------------------------------
   /SJ
   WorkingDirectory = "(*INSTALLDIR*)"
   ApplicationName = "%COMSPEC%"
   Parameters = "/C echo %DATE% %TIME%: SillySchedule1 says hello... >> \SillySchedule1.log 2>&1"
   Comment = "This is a comment for the schedule (INSTALLDIR = '(*INSTALLDIR*)')"
   MaxRunTime = 3600000                            ;;1 hour in milliseconds
   KillIfGoingOnBatteries = 0
   SystemRequired = 1

   ;--- Create a trigger (you can create more than one) ---------------------
   /CTJ
   Type = Weekly
   TypeArguments = 1,.M.W.F.     ;;Every Monday, Wenesday and Friday
   StartTime = 06:00             ;;6:00am
   MinutesDuration = 600         ;;For 10 hours
   MinutesInterval = 60          ;;Repeated every one hour
   HasEndDate = 0                ;;Never Ends
   EndDate = 00/00/0000
   KillAtDuration = 1            ;;Terminate if still running (after "MinutesDuration")
   Disabled = 0                  ;;Not Disabled

   ;--- Security Info (use system account) ----------------------------------
   /SC "" NULL
<$/Schedule>
;---[4Doco-SimpleJtExeBasedSchedule]---



;############################################################################
;############################################################################
;################ Any following lines apply to Schedule #2 ##################
;############################################################################
;############################################################################



;-----------------------------------------------------------------------------
;--- Create a simple VBS we will execute for the schedule (add to package) ---
;-----------------------------------------------------------------------------
#define SCHEDULE2.VBS_SHORT_NAME  Schedule2.VBS
#define SCHEDULE2.VBS             <$MAKEMSI_VBSCRIPT_DIR>\<$SCHEDULE2.VBS_SHORT_NAME>
<$FileMake "<$SCHEDULE2.VBS>">
    ;--- Syntax check the generated code ------------------------------------
    <?SyntaxCheck>

    ;--- Initialization -----------------------------------------------------
    dim oFS    : set oFS    = CreateObject("Scripting.FileSystemObject")
    dim oShell : set oShell = CreateObject("WScript.Shell")

    ;--- Do something basic -------------------------------------------------
    wscript.echo "Product: <$ProdInfo.ProductName>"
    wscript.echo "Version: <$ProductVersion>"
    wscript.echo ""
    wscript.echo "This is the second schedule's VBSCRIPT saying hello..."

    ;--- Return with a return code of zero ----------------------------------
    wscript.quit 0
<$/FileMake>
<$Files "<$SCHEDULE2.VBS>" DestDir="INSTALLDIR">  ;;Adding file to installed files


;----------------------------------------------------------------------------
;--- Create a Batch file that the schedule will run (logs VBSCRIPT) ---------
;----------------------------------------------------------------------------
#define SCHEDULE2.CMD_SHORT_NAME  SCHEDULE2.CMD
#define SCHEDULE2.LOG_DIR         \SCHEDULE2            ;;Off root (our schedule will run under system account and so will be able to write here)
#define SCHEDULE2.CMD             <$MAKEMSI_OTHER_DIR>\<$SCHEDULE2.CMD_SHORT_NAME>
<$FileMake "<$SCHEDULE2.CMD>">
   @rem --- Init (current directory will be INSTALLDIR) ---------------------
   @echo off
   setlocal
   set  LogDir=<$SCHEDULE2.LOG_DIR>
   md "%LogDir%" >nul 2>&1
   set  LogFile=%LogDir%\Schedule2.TXT
   set LogFile1=%LogDir%\Schedule2-1.TXT
   set LogFile2=%LogDir%\Schedule2-2.TXT
   set LogFile3=%LogDir%\Schedule2-3.TXT
   set LogFile4=%LogDir%\Schedule2-4.TXT
   set LogFile5=%LogDir%\Schedule2-5.TXT
   set LogFile6=%LogDir%\Schedule2-6.TXT
   set LogFile7=%LogDir%\Schedule2-7.TXT

   ;--- Output Message ------------------------------------------------------
   echo ***
   echo *** Simple message
   echo *** Seen if user kicks off this batch file directly - disallow if this is bad...
   echo ***
   echo.

   <?NewLine>
   @REM --- Roll logs -------------------------------------------------------
   del  "%LogFile7%"                    >nul 2>&1
   copy "%LogFile6%" "%LogFile7%"       >nul 2>&1
   copy "%LogFile5%" "%LogFile6%"       >nul 2>&1
   copy "%LogFile4%" "%LogFile5%"       >nul 2>&1
   copy "%LogFile3%" "%LogFile4%"       >nul 2>&1
   copy "%LogFile2%" "%LogFile3%"       >nul 2>&1
   copy "%LogFile1%" "%LogFile2%"       >nul 2>&1
   copy "%LogFile%"  "%LogFile1%"       >nul 2>&1
   del  "%LogFile%"                     >nul 2>&1

   <?NewLine>
   @rem --- Execute the VBS -------------------------------------------------
   echo %DATE%, %TIME%: Starting the Schedule2 task...     > "%LogFile%"
   echo.                                                  >> "%LogFile%"
   cscript.exe //NoLogo "<$SCHEDULE2.VBS_SHORT_NAME>"     >> "%LogFile%" 2>&1
   echo.                                                  >> "%LogFile%"
   echo %DATE%, %TIME%: Finished the Schedule2 task...    >> "%LogFile%"
<$/FileMake>
<$Files "<$SCHEDULE2.CMD>" DestDir="INSTALLDIR">  ;;Adding file to installed files


;----------------------------------------------------------------------------
;--- Create Schedule #2: A batch file which invokes a VBS and logs ----------
;----------------------------------------------------------------------------
<$Schedule "SillySchedule2 - (*Schedule2Comment*)" DATA="CAD_SCHEDULE" JT.EXE=^[INSTALLDIR]JT.EXE^>
   ;--- Task Information ----------------------------------------------------
   /SJ
   WorkingDirectory = "(*INSTALLDIR*)"
   ApplicationName = "%COMSPEC%"                   ;;Run batch file via command processor
   Parameters = "/C <$SCHEDULE2.CMD_SHORT_NAME>"
   Comment = "Schedule 2"
   MaxRunTime = 3600000                            ;;1 hour in milliseconds
   KillIfGoingOnBatteries = 0
   SystemRequired = 1

   ;--- Create a trigger (you can create more than one) ---------------------
   /CTJ
   Type = Daily
   TypeArguments = 1
   EndDate = 00/00/0000
   StartTime = 13:00                ;;Starts 1pm
   MinutesDuration=60
   KillAtDuration=1
   Disabled = 0

   ;--- Security Info (use system account) ----------------------------------
   /SC "" NULL
<$/Schedule>